<?php
header('Content-Type: application/json; charset=utf-8');

define("APP_INIT", true);
require "/home/mstrxgcf/terminate-app/lib.php";

if($_SERVER['REQUEST_METHOD'] !== 'POST'){
  echo json_encode(["ok"=>false,"msg"=>"POST required"], JSON_UNESCAPED_UNICODE);
  exit;
}

$action = trim($_POST['action'] ?? '');

function ok($extra=[]){ echo json_encode(array_merge(["ok"=>true],$extra), JSON_UNESCAPED_UNICODE); exit; }
function fail($msg){ echo json_encode(["ok"=>false,"msg"=>$msg], JSON_UNESCAPED_UNICODE); exit; }

try{
  if($action === 'clear_cache'){
    clear_cache_all();
    ok(["msg"=>"cache cleared"]);
  }

  if($action === 'run_cron'){
    $n = run_cron_scan();
    ok(["msg"=>"cron ok","terminated"=>$n]);
  }

  if($action === 'save_limit'){
    $csv = basename((string)($_POST['csv'] ?? ''));
    $limit = (float)($_POST['limit'] ?? DEFAULT_LIMIT_USD);
    if($csv === '' || $limit <= 0) fail("csv/limit invalid");
    set_account_limit_for_csv($csv, $limit);
    clear_cache_all();
    ok(["msg"=>"limit saved"]);
  }

  if($action === 'save_note'){
    $csv = basename((string)($_POST['csv'] ?? ''));
    $note = (string)($_POST['note'] ?? '');
    if($csv === '') fail("csv invalid");
    set_account_note_for_csv($csv, $note);
    ok(["msg"=>"note saved"]);
  }

  if($action === 'delete_account'){
    $csv = basename((string)($_POST['csv'] ?? ''));
    if($csv === '') fail("csv invalid");
    $r = delete_account_csv($csv);
    if(!$r) fail("csv not found");
    ok(["msg"=>"account deleted"]);
  }

  if($action === 'terminate_one'){
    $csv = basename((string)($_POST['csv'] ?? ''));
    $region = (string)($_POST['region'] ?? '');
    $instance = (string)($_POST['instance'] ?? '');
    if($csv===''||$region===''||$instance==='') fail("csv/region/instance required");
    terminate_one_instance_by_csv($csv, $region, $instance);
    ok(["msg"=>"terminate sent"]);
  }

  fail("unknown action");

}catch(Throwable $e){
  http_response_code(500);
  fail($e->getMessage());
}