(function(){
  const qs = (s, el=document)=>el.querySelector(s);
  const qsa = (s, el=document)=>Array.from(el.querySelectorAll(s));

  // Accordion toggle
  qsa('[data-acc-toggle]').forEach(btn=>{
    btn.addEventListener('click', ()=>{
      const id = btn.getAttribute('data-acc-toggle');
      const box = qs(#details-${CSS.escape(id)});
      if(!box) return;
      box.classList.toggle('open');
      btn.setAttribute('aria-expanded', box.classList.contains('open') ? 'true':'false');
      btn.innerHTML = box.classList.contains('open') ? '▾' : '▸';
    });
  });

  // Client-side search filter (account cards)
  const input = qs('#searchBox');
  if(input){
    input.addEventListener('input', ()=>{
      const q = input.value.trim().toLowerCase();
      qsa('[data-acc-row]').forEach(row=>{
        const hay = (row.getAttribute('data-hay')||'').toLowerCase();
        row.style.display = hay.includes(q) ? '' : 'none';
      });
    });
  }

  // Filter: only over limit (button toggles)
  const overBtn = qs('#btnOver');
  if(overBtn){
    overBtn.addEventListener('click', ()=>{
      const on = overBtn.getAttribute('data-on') === '1';
      overBtn.setAttribute('data-on', on ? '0' : '1');
      overBtn.classList.toggle('btnWarn', !on);
      qsa('[data-acc-row]').forEach(row=>{
        if(overBtn.getAttribute('data-on') === '1'){
          row.style.display = row.getAttribute('data-over') === '1' ? '' : 'none';
        } else {
          row.style.display = '';
        }
      });
    });
  }
})();