<?php
ini_set('display_errors',0);
error_reporting(E_ALL);

require '/home/mstrxgcf/terminate-app/lib.php';
global $ALLOW_IPS;

enforce_ip_allowlist($ALLOW_IPS);
require_basic_auth_if_enabled();

session_start();
if(empty($_SESSION['csrf'])) $_SESSION['csrf']=bin2hex(random_bytes(16));

$data = list_instances_all_accounts();
$items = isset($data['items']) ? $data['items'] : array();
$errors= isset($data['errors'])? $data['errors'] : array();

$accs = credentials_by_account();
$allAccounts = array_keys($accs);
$groups = group_by_account($items, $allAccounts);

$notes = load_notes();

$statusByAcc = array();
$overAccounts = array();
$warnAccounts = array();

$ceMonthByAcc = array();
$ce24ByAcc    = array();

foreach($accs as $acc=>$c){
  $rows = isset($groups[$acc]) ? $groups[$acc] : array();
  $st = account_status($acc, $rows);
  $statusByAcc[$acc] = $st;

  if($st['over']) $overAccounts[$acc] = $st;
  else if($st['warn']) $warnAccounts[$acc] = $st;

  $m = ce_month_for_account($acc, $c['ak'], $c['sk']);
  $h = ce_last24_for_account($acc, $c['ak'], $c['sk']);

  // CE 0.00 ama uptime$ > 0 ise: NA göster (CE yanlış/erişim yok/linked filtre tutmuyor)
  if(is_numeric($m) && (float)$m <= 0.000001 && $st['known'] && (float)$st['sum'] > 0.01){
    log_err("CE month returned 0 but uptime$>0 [$acc] -> show NA");
    $m = 'NA';
  }
  if(is_numeric($h) && (float)$h <= 0.000001 && $st['known'] && (float)$st['sum'] > 0.01){
    log_err("CE 24h returned 0 but uptime$>0 [$acc] -> show NA");
    $h = 'NA';
  }

  $ceMonthByAcc[$acc] = $m;
  $ce24ByAcc[$acc]    = $h;
}

$autoActions = auto_terminate_if_needed($groups);

$terminatedList = load_terminated_list(); // auto-terminate çalışanlar
$overlimitList  = load_overlimit_list();  // limit dolanlar (kalıcı)

$total=count($items);
$running=0;
foreach($items as $it) if(isset($it['state']) && $it['state']==='running') $running++;

$fmtCE = function($v){
  if($v==='DU') return '<span class="ce ceDU">DU</span>';
  if($v==='NA' || $v===null) return '<span class="ce ceNA">NA</span>';
  return '<span class="ce ceOK">$'.number_format((float)$v,2).'</span>';
};
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>EC2 Dashboard</title>
<style>
  body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial;margin:22px;background:#0b1220;color:#e6eaf2}
  .wrap{max-width:1380px;margin:0 auto}
  .card{background:#111a2e;border:1px solid #223055;border-radius:16px;padding:14px 16px;box-shadow:0 10px 30px rgba(0,0,0,.25)}
  .row{display:flex;gap:10px;flex-wrap:wrap;align-items:center}
  .small{color:#aab3c7;font-size:12px}
  .pill{padding:6px 10px;border-radius:999px;background:#162247;border:1px solid #2a3b69;font-size:13px}
  .ok{background:#12361f;border-color:#1f6b3a}
  .warn{background:#3b2a12;border-color:#8a5b1e}
  .bad{background:#3b1216;border-color:#8a1e2a}
  .search{padding:10px 12px;border-radius:12px;border:1px solid #223055;background:#0f1730;color:#e6eaf2;min-width:340px}

  .tabs{display:flex;gap:10px;flex-wrap:wrap;margin-top:12px}
  .tab{padding:10px 12px;border-radius:14px;border:1px solid #223055;background:#0f1730;color:#e6eaf2;cursor:pointer}
  .tab.active{background:#2d6cdf;border-color:rgba(255,255,255,.12)}
  .panel{display:none;margin-top:14px}
  .panel.active{display:block}

  .btn{display:inline-flex;align-items:center;gap:8px;padding:10px 12px;border-radius:12px;border:1px solid rgba(255,255,255,.12);cursor:pointer;
       background:#2d6cdf;color:#fff;transition:.12s transform,.12s opacity}
  .btn:hover{transform:translateY(-1px);opacity:.96}
  .btn:active{transform:translateY(0)}
  .btnGhost{background:transparent}
  .btnDanger{background:#d9534f}
  .btnSmall{padding:8px 10px;border-radius:11px;font-size:13px}
  .icon{font-weight:900;opacity:.95}

  .acc{margin-top:12px}
  .accHead{display:flex;align-items:flex-start;justify-content:space-between;gap:12px;flex-wrap:wrap;cursor:pointer;user-select:none}
  .accTitle{display:flex;align-items:flex-start;gap:10px}
  .chev{display:inline-block;transition:transform .15s ease;margin-top:2px}
  .acc.open .chev{transform:rotate(90deg)}
  .accBody{display:none}
  .acc.open .accBody{display:block}
  .groupName{font-size:16px;font-weight:900}
  .tag{display:inline-block;padding:4px 10px;border-radius:999px;font-size:12px;border:1px solid #2a3b69;background:#162247}
  table{width:100%;border-collapse:separate;border-spacing:0;margin-top:12px}
  th,td{padding:10px 10px;border-bottom:1px solid #223055;font-size:13px;vertical-align:top}
  th{position:sticky;top:0;background:#111a2e;text-align:left;z-index:2}
  tr:hover td{background:#0f1730}
  .right{text-align:right;white-space:nowrap}

  .limitInput{width:92px; padding:8px 10px; border-radius:12px;border:1px solid #223055; background:#0f1730; color:#e6eaf2;}
  .noteBox{width:360px;max-width:80vw;min-height:38px; padding:10px 12px; border-radius:12px;border:1px solid #223055; background:#0f1730; color:#e6eaf2;}
  .badge{padding:6px 10px;border-radius:12px;font-weight:900}
  .bGreen{background:#18c56e;color:#04130b}
  .bYellow{background:#ffd54a;color:#1a1200}
  .bRed{background:#ff4d4d;color:#240000}

  .ce{display:inline-block;padding:5px 10px;border-radius:999px;border:1px solid #2a3b69;font-size:12px}
  .ceOK{background:#12361f;border-color:#1f6b3a}
  .ceDU{background:#3b2a12;border-color:#8a5b1e}
  .ceNA{background:#0f1730;border-color:#223055;color:#aab3c7}

  /* Modal */
  .modalBack{position:fixed;inset:0;background:rgba(0,0,0,.55);display:none;align-items:center;justify-content:center;z-index:999}
  .modal{width:min(560px,92vw);background:#111a2e;border:1px solid #223055;border-radius:16px;padding:14px 16px;box-shadow:0 20px 60px rgba(0,0,0,.45)}
  .modalBack.show{display:flex}
  .modal h3{margin:0 0 6px 0}
  .modal .line{height:1px;background:#223055;margin:10px 0}
  .chk{display:flex;gap:10px;align-items:flex-start;margin-top:10px}
  input[type="checkbox"]{transform:scale(1.2);margin-top:3px}
</style>
<script>
  const CSRF = <?= json_encode($_SESSION['csrf']) ?>;

  function setTab(id){
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    document.querySelectorAll('.panel').forEach(p=>p.classList.remove('active'));
    document.getElementById('tab_'+id).classList.add('active');
    document.getElementById('panel_'+id).classList.add('active');
  }

  function toggleAcc(id){ const el=document.getElementById(id); if(el) el.classList.toggle('open'); }
  function stop(ev){ ev.stopPropagation(); }

  function filterRows(){
    const q=(document.getElementById('q').value||'').toLowerCase();
    document.querySelectorAll('[data-acc]').forEach(n=>{
      n.style.display = n.innerText.toLowerCase().indexOf(q)>=0 ? '' : 'none';
    });
  }

  async function post(action, data){
    const fd=new FormData();
    fd.append('csrf', CSRF);
    fd.append('action', action);
    for(const k in data) fd.append(k, data[k]);
    const r=await fetch('run.php',{method:'POST',body:fd});
    return await r.json();
  }

  async function clearCache(){
    const r=await post('clear_cache',{});
    alert(r.msg||'');
    location.reload();
  }

  async function setLimit(acc, inpId){
    const v=document.getElementById(inpId).value;
    const r=await post('set_limit',{account:acc,limit:v});
    alert(r.msg||'');
    location.reload();
  }

  async function saveNote(acc, taId){
    const note=document.getElementById(taId).value;
    const r=await post('set_note',{account:acc,note:note});
    alert(r.msg||'');
    location.reload();
  }

  async function term(acc, region, id){
    if(!confirm('Terminate edilecek. Emin misin?')) return;
    const r=await post('terminate_one',{account:acc,region:region,id:id});
    alert(r.msg||'');
    location.reload();
  }

  // Delete modal
  let DEL = {csv:'', name:''};
  function openDeleteModal(csvBase, accName){
    DEL.csv=csvBase; DEL.name=accName;
    document.getElementById('del_name').innerText = accName;
    document.getElementById('del_csv').innerText  = csvBase;
    document.getElementById('del_chk').checked=false;
    document.getElementById('del_btn').disabled=true;
    document.getElementById('modalBack').classList.add('show');
  }
  function closeDeleteModal(){
    document.getElementById('modalBack').classList.remove('show');
  }
  function onDelCheck(){
    const ok=document.getElementById('del_chk').checked;
    document.getElementById('del_btn').disabled=!ok;
  }
  async function doDelete(){
    if(!document.getElementById('del_chk').checked) return;
    const r=await post('delete_account',{csv:DEL.csv,confirm:'YES'});
    alert(r.msg||'');
    location.reload();
  }
</script>
</head>
<body>
<div class="wrap">

  <div class="card">
    <div class="row" style="justify-content:space-between">
      <div>
        <div style="font-size:18px;font-weight:900">EC2 Dashboard</div>
        <div class="small">Limit tetik: <b>UPTIME $</b> • CE: <b>gösterim</b> (0.00 gelirse ve uptime$>0 ise NA)</div>
      </div>
      <div class="row">
        <button class="btn btnSmall" onclick="location.reload()"><span class="icon">↻</span> Yenile</button>
        <button class="btn btnGhost btnSmall" onclick="clearCache()"><span class="icon">🧹</span> Cache</button>
      </div>
    </div>

    <div class="row" style="margin-top:10px">
      <div class="pill">Hesap: <b><?= count($groups) ?></b></div>
      <div class="pill">Toplam: <b><?= $total ?></b></div>
      <div class="pill ok">Running: <b><?= $running ?></b></div>
      <div class="pill warn">Limit dolan: <b><?= count($overAccounts) ?></b></div>
    </div>

    <div class="row" style="margin-top:10px">
      <input id="q" class="search" placeholder="Ara: hesap / bölge / OS / type..." oninput="filterRows()">
    </div>

    <div class="tabs">
      <div id="tab_main" class="tab active" onclick="setTab('main')">Aktif Panel</div>
      <div id="tab_alerts" class="tab" onclick="setTab('alerts')">Limit / Terminate Sekmesi</div>
      <div id="tab_errors" class="tab" onclick="setTab('errors')">Hatalar</div>
    </div>
  </div>

  <!-- PANEL: MAIN -->
  <div id="panel_main" class="panel active">
    <?php $i=0; foreach($groups as $acc=>$rows): $i++; ?>
      <?php
        $st = isset($statusByAcc[$acc]) ? $statusByAcc[$acc] : account_status($acc,$rows);
        $limit = (float)$st['limit'];
        $base  = (float)$st['sum'];
        $ratio = ($limit>0) ? ($base/$limit) : 0;

        $badge = 'bGreen';
        if($ratio>=1.0) $badge='bRed';
        else if($ratio>=(float)WARN_RATIO) $badge='bYellow';

        $cem = isset($ceMonthByAcc[$acc]) ? $ceMonthByAcc[$acc] : 'NA';
        $ce24= isset($ce24ByAcc[$acc]) ? $ce24ByAcc[$acc] : 'NA';

        $accId="acc_$i";
        $inpId="lim_$i";
        $noteId="note_$i";
        $csvBase = isset($accs[$acc]['csv_base']) ? $accs[$acc]['csv_base'] : '';
        $noteVal = isset($notes[$acc]) ? $notes[$acc] : '';
      ?>
      <div id="<?= $accId ?>" class="card acc" data-acc>
        <div class="accHead" onclick="toggleAcc('<?= $accId ?>')">
          <div class="accTitle">
            <span class="chev">▶</span>
            <div>
              <div class="groupName"><?= htmlspecialchars($acc) ?></div>
              <div class="row" style="margin-top:6px">
                <span class="pill">Running: <b><?= (int)$st['running'] ?></b></span>
                <span class="pill">Saat: <b><?= number_format((float)$st['hours'],2) ?>h</b></span>
                <span class="pill">Uptime $: <b>$<?= number_format($base,2) ?></b></span>
                <span class="pill">CE 24h: <?= $fmtCE($ce24) ?></span>
                <span class="pill">CE ay: <?= $fmtCE($cem) ?></span>
                <?php if($st['over']): ?><span class="pill bad">✅ LIMIT DOLDU</span><?php endif; ?>
                <?php if(!$st['over'] && $st['warn']): ?><span class="pill warn">⚠ YAKLAŞTI</span><?php endif; ?>
              </div>
              <?php if($noteVal!==''): ?>
                <div class="small" style="margin-top:6px;color:#cfd6ea">📝 <?= htmlspecialchars($noteVal) ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="row" onclick="stop(event)">
            <div class="badge <?= $badge ?>">$<?= number_format($base,2) ?> / <?= number_format($limit,0) ?></div>
            <input id="<?= $inpId ?>" class="limitInput" type="number" step="0.01" min="1" value="<?= htmlspecialchars((string)$limit) ?>">
            <button class="btn btnSmall" onclick="setLimit(<?= json_encode($acc) ?>, <?= json_encode($inpId) ?>)"><span class="icon">💾</span> Limit</button>
            <button class="btn btnGhost btnSmall" onclick="openDeleteModal(<?= json_encode($csvBase) ?>, <?= json_encode($acc) ?>)"><span class="icon">🗑</span> Sil</button>
          </div>
        </div>

        <div class="accBody" style="margin-top:10px">
          <div class="row" onclick="stop(event)">
            <textarea id="<?= $noteId ?>" class="noteBox" placeholder="Bu hesap için not yaz (örn: reklam test, 2 gün açık kalsın)"><?= htmlspecialchars($noteVal) ?></textarea>
            <button class="btn btnSmall" onclick="saveNote(<?= json_encode($acc) ?>, <?= json_encode($noteId) ?>)"><span class="icon">📝</span> Not Kaydet</button>
          </div>

          <?php if(empty($rows)): ?>
            <div class="small" style="margin-top:10px">Bu hesapta listelenecek instance yok.</div>
          <?php else: ?>
            <table>
              <thead>
                <tr>
                  <th>Bölge</th><th>OS</th><th>Type</th><th>State</th>
                  <th class="right">Çalışma</th><th class="right">$/saat</th><th class="right">Tahmini $</th>
                  <th class="right">İşlem</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach($rows as $r): ?>
                <tr>
                  <td><span class="tag"><?= htmlspecialchars($r['region_name']) ?></span></td>
                  <td><span class="tag"><?= htmlspecialchars($r['os']) ?></span></td>
                  <td><span class="tag"><?= htmlspecialchars($r['type']) ?></span></td>
                  <td><b><?= htmlspecialchars($r['state']) ?></b></td>
                  <td class="right"><span class="tag"><?= htmlspecialchars($r['uptime_label']) ?></span></td>
                  <td class="right"><?= ($r['hourly_usd']===null) ? '<span class="small">N/A</span>' : '$'.number_format((float)$r['hourly_usd'],6) ?></td>
                  <td class="right"><?= ($r['est_cost_usd']===null) ? '<span class="small">N/A</span>' : '$'.number_format((float)$r['est_cost_usd'],4) ?></td>
                  <td class="right">
                    <?php if($r['state']==='running'): ?>
                      <button class="btn btnDanger btnSmall" onclick="term(<?= json_encode($acc) ?>, <?= json_encode($r['region']) ?>, <?= json_encode($r['id']) ?>)"><span class="icon">⛔</span> Terminate</button>
                    <?php else: ?>
                      <span class="small">—</span>
                    <?php endif; ?>
                  </td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <!-- PANEL: ALERTS TAB -->
  <div id="panel_alerts" class="panel">
    <div class="card">
      <div style="font-weight:900">📌 Limit Dolan Hesaplar (Kalıcı)</div>
      <div class="small" style="margin-top:8px">
        <?php if(empty($overlimitList)): ?>
          Liste boş.
        <?php else: ?>
          <?php foreach($overlimitList as $acc=>$info): ?>
            • <b><?= htmlspecialchars($acc) ?></b> — <?= htmlspecialchars($info['ts']) ?> • cost $<?= number_format((float)$info['cost'],2) ?> / limit $<?= number_format((float)$info['limit'],2) ?> • running <?= (int)$info['running'] ?><br>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>

    <div class="card" style="margin-top:14px;border-color:#ff4d4d;background:#3b1216">
      <div style="font-weight:900">🧾 Auto-Terminate Çalıştırılan Hesaplar (Kalıcı)</div>
      <div class="small" style="margin-top:8px">
        <?php if(empty($terminatedList)): ?>
          Liste boş.
        <?php else: ?>
          <?php foreach($terminatedList as $acc=>$info): ?>
            • <b><?= htmlspecialchars($acc) ?></b> — <?= htmlspecialchars($info['ts']) ?> • cost $<?= number_format((float)$info['cost'],2) ?> / limit $<?= number_format((float)$info['limit'],2) ?> • killed <?= (int)$info['killed'] ?><br>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- PANEL: ERRORS -->
  <div id="panel_errors" class="panel">
    <div class="card">
      <div style="font-weight:900">Hatalar / Log</div>
      <div class="small" style="margin-top:8px">
        <?php if(empty($errors)): ?>
          Hata yok.
        <?php else: ?>
          <?php foreach($errors as $e): ?><div>• <?= htmlspecialchars($e) ?></div><?php endforeach; ?>
        <?php endif; ?>
      </div>
      <div class="small" style="margin-top:10px;color:#aab3c7">
        CE çalışmıyorsa: IAM “ce:GetCostAndUsage” gerekir + hesapta Cost Explorer aktif olmalı. (Aktif değilse NA/DU görürsün.)
      </div>
    </div>
  </div>

</div>

<!-- Delete Modal -->
<div id="modalBack" class="modalBack" onclick="closeDeleteModal()">
  <div class="modal" onclick="event.stopPropagation()">
    <h3>Hesabı Sil</h3>
    <div class="small">Hesap: <b id="del_name"></b></div>
    <div class="small">CSV: <b id="del_csv"></b></div>
    <div class="line"></div>
    <div class="small">Bu işlem CSV’yi <b>keys/.trash</b> içine taşır. Panelden kaldırır.</div>
    <div class="chk">
      <input id="del_chk" type="checkbox" onchange="onDelCheck()">
      <div class="small"><b>Onaylıyorum</b>, bu hesabı panelden kaldır.</div>
    </div>
    <div class="row" style="justify-content:flex-end;margin-top:12px">
      <button class="btn btnGhost btnSmall" onclick="closeDeleteModal()">Vazgeç</button>
      <button id="del_btn" class="btn btnDanger btnSmall" onclick="doDelete()" disabled>Sil</button>
    </div>
  </div>
</div>

</body>
</html>