<?php ?><!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>EC2 Control Panel</title>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">

<style>
:root{
  --canvas:#f6f8fc;
  --card:#ffffff;
  --text:#0b1220;
  --muted:#5b6b84;
  --border:#e5eaf4;

  --primary:#2563eb;
  --primary2:#1d4ed8;

  --success:#16a34a;
  --warning:#f59e0b;
  --danger:#ef4444;

  --shadow: 0 18px 40px rgba(15,23,42,.12);
  --shadow2: 0 10px 22px rgba(15,23,42,.10);

  --r:18px;
  --r2:14px;

  --sans: Inter, ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Arial;
  --mono: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono","Courier New", monospace;
}
*{box-sizing:border-box}
html,body{height:100%}
body{
  margin:0;
  font-family:var(--sans);
  color:var(--text);
  background:
    radial-gradient(1000px 600px at 10% 10%, rgba(37,99,235,.16), transparent 55%),
    radial-gradient(900px 550px at 90% 12%, rgba(245,158,11,.12), transparent 60%),
    radial-gradient(900px 600px at 50% 95%, rgba(22,163,74,.10), transparent 60%),
    var(--canvas);
}

.app{display:grid;grid-template-columns:310px 1fr;gap:16px;padding:16px;min-height:100vh}

/* Sidebar */
.sidebar{
  position:sticky;top:16px;height:calc(100vh - 32px);overflow:auto;
  border-radius:var(--r);
  background:
    radial-gradient(900px 500px at 10% 0%, rgba(96,165,250,.22), transparent 55%),
    linear-gradient(180deg, #0e1730, #0b1220);
  box-shadow:var(--shadow);
  padding:14px;
  color:#eaf0ff;
  border:1px solid rgba(255,255,255,.08);
}
.brand{display:flex;gap:12px;align-items:center;padding:12px;border-radius:16px;background:rgba(255,255,255,.06);border:1px solid rgba(255,255,255,.10)}
.logo{width:40px;height:40px;border-radius:14px;background:linear-gradient(135deg,#60a5fa,#2563eb);box-shadow:0 14px 26px rgba(37,99,235,.35)}
.brand .t{font-weight:900;letter-spacing:.2px;font-size:14px}
.brand .s{margin-top:3px;font-size:12px;color:rgba(234,240,255,.76)}
.nav{margin-top:12px;display:flex;flex-direction:column;gap:8px}
.nav button{all:unset;cursor:pointer;display:flex;align-items:center;justify-content:space-between;gap:12px;padding:11px 12px;border-radius:14px;border:1px solid transparent;background:rgba(255,255,255,.04)}
.nav button:hover{background:rgba(255,255,255,.07);border-color:rgba(255,255,255,.12)}
.nav button.active{background:linear-gradient(135deg, rgba(96,165,250,.22), rgba(37,99,235,.18));border-color:rgba(96,165,250,.35)}
.nav .left{display:flex;align-items:center;gap:10px;min-width:0}
.ico{width:18px;height:18px;opacity:.95}
.nav .lbl{font-weight:800;font-size:13px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
.pill{font-size:12px;padding:2px 9px;border-radius:999px;border:1px solid rgba(255,255,255,.16);background:rgba(0,0,0,.12);color:#eaf0ff}
.sidebox{margin-top:auto;padding:12px;border-radius:16px;background:rgba(255,255,255,.06);border:1px solid rgba(255,255,255,.10)}
.sidebox .row{display:flex;justify-content:space-between;gap:12px;margin:8px 0;font-size:12px;color:rgba(234,240,255,.78)}
.sidebox b{color:#fff}

/* Main */
.main{display:flex;flex-direction:column;gap:14px}
.header{
  border-radius:var(--r);
  background:rgba(255,255,255,.86);
  border:1px solid var(--border);
  box-shadow:var(--shadow2);
  padding:14px;
  display:flex;align-items:center;justify-content:space-between;gap:12px;flex-wrap:wrap;
  backdrop-filter:blur(8px);
}
.hgroup .h1{margin:0;font-weight:950;font-size:16px;letter-spacing:.2px}
.hgroup .sub{margin-top:6px;font-size:12px;color:var(--muted)}
.actions{display:flex;gap:10px;flex-wrap:wrap;justify-content:flex-end}

/* Buttons */
.btn{
  border-radius:14px;border:1px solid var(--border);background:#fff;
  padding:10px 12px;font-weight:900;font-size:13px;color:var(--text);
  cursor:pointer;box-shadow:0 10px 18px rgba(15,23,42,.06);
  display:inline-flex;align-items:center;gap:8px;
}
.btn:hover{background:#fbfdff;border-color:#dfe6f3}
.btn:active{transform:translateY(1px)}
.btn svg{width:16px;height:16px;opacity:.9}
.btn.primary{background:linear-gradient(135deg,var(--primary),var(--primary2));border-color:transparent;color:#fff;box-shadow:0 14px 26px rgba(37,99,235,.22)}
.btn.ghost{background:rgba(37,99,235,.08);border-color:rgba(37,99,235,.18);color:#113a9f}
.btn.danger{background:rgba(239,68,68,.08);border-color:rgba(239,68,68,.18);color:#8b1a1a}
.btn.small{padding:8px 10px;border-radius:12px;font-size:12px;box-shadow:none}

/* KPI */
.kpis{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:12px}
.kpi{
  border-radius:var(--r);
  background:rgba(255,255,255,.92);
  border:1px solid var(--border);
  box-shadow:var(--shadow2);
  padding:14px;
  position:relative;overflow:hidden;
}
.kpi:before{
  content:"";position:absolute;inset:-40px -60px auto auto;width:160px;height:160px;
  background:radial-gradient(circle at 30% 30%, rgba(96,165,250,.35), transparent 60%);
  transform:rotate(20deg);
}
.kpi .top{display:flex;justify-content:space-between;gap:10px;align-items:center;position:relative}
.kpi .label{font-size:12px;color:var(--muted);font-weight:800}
.kpi .tag{font-size:12px;padding:3px 10px;border-radius:999px;border:1px solid var(--border);background:#fff;font-weight:900}
.tag.ok{border-color:#d1fae5;background:#ecfdf5;color:#065f46}
.tag.warn{border-color:#ffedd5;background:#fff7ed;color:#9a3412}
.kpi .value{margin-top:10px;font-size:28px;font-weight:950;position:relative}
.kpi .hint{margin-top:8px;font-size:12px;color:var(--muted);position:relative}

/* Toolbar */
.toolbar{
  border-radius:var(--r);
  background:rgba(255,255,255,.92);
  border:1px solid var(--border);
  box-shadow:var(--shadow2);
  padding:12px;
  display:flex;gap:10px;align-items:center;flex-wrap:wrap;
}
.search{
  flex:1;min-width:260px;
  display:flex;align-items:center;gap:10px;
  padding:10px 12px;border-radius:999px;background:#fff;border:1px solid var(--border);
}
.search input{width:100%;border:none;outline:none;font-size:13px}
.select{border-radius:999px;border:1px solid var(--border);background:#fff;padding:10px 12px;font-size:13px;outline:none}
.meta{margin-left:auto;font-size:12px;color:var(--muted);font-weight:800}

/* List */
.list{
  border-radius:var(--r);
  background:rgba(255,255,255,.94);
  border:1px solid var(--border);
  box-shadow:var(--shadow2);
  overflow:hidden;
}
.listhead{
  padding:12px 14px;
  display:flex;justify-content:space-between;align-items:center;gap:12px;
  border-bottom:1px solid var(--border);
  background:linear-gradient(180deg,#fff,#f7faff);
}
.pages{display:flex;gap:8px;align-items:center}
.pagebtn{border:1px solid var(--border);background:#fff;border-radius:12px;padding:8px 10px;cursor:pointer;font-weight:950}
.pagebtn:hover{background:#fbfdff}
.pageinfo{font-size:12px;color:var(--muted);font-weight:900}

/* Account bars (renkli + okunabilir) */
.account{
  border-top:1px solid var(--border);
  padding:10px 14px;
  position:relative;
}
.account:first-child{border-top:none}
.account::before{
  content:"";
  position:absolute;left:0;top:0;bottom:0;width:6px;border-radius:6px;
  background:linear-gradient(180deg, rgba(37,99,235,.95), rgba(96,165,250,.75));
}
.account.over::before{
  background:linear-gradient(180deg, rgba(239,68,68,.95), rgba(245,158,11,.85));
}
.account:hover{background:linear-gradient(180deg, #ffffff, #fbfdff)}
.accRow{
  display:grid;
  grid-template-columns: 1fr 360px;
  gap:12px;
  align-items:center;
  cursor:pointer;
  border-radius:16px;
  padding:10px 10px;
}
.accRow:active{transform:translateY(1px)}
.nameLine{display:flex;align-items:center;gap:10px;flex-wrap:wrap}
.name{
  font-weight:950;font-size:14px;letter-spacing:.2px;
  white-space:nowrap;overflow:hidden;text-overflow:ellipsis;max-width:560px;
}
.badge{
  font-size:12px;padding:3px 10px;border-radius:999px;border:1px solid var(--border);
  background:#fff;color:var(--muted);font-weight:900;
}
.badge.green{border-color:#d1fae5;background:#ecfdf5;color:#065f46}
.badge.red{border-color:#fee2e2;background:#fff5f5;color:#991b1b}
.chips{display:flex;gap:8px;flex-wrap:wrap;margin-top:8px}
.chip{
  display:inline-flex;align-items:center;gap:8px;
  font-size:12px;padding:4px 10px;border-radius:999px;border:1px solid var(--border);
  background:#fff;font-weight:900;color:#0b1220;
}
.chip.mono{font-family:var(--mono);font-size:11px;color:#334155;font-weight:800}

/* Right */
.accRight{display:flex;gap:10px;justify-content:flex-end;flex-wrap:wrap;align-items:center}
.progress{min-width:190px;max-width:240px;flex:1}
.prow{display:flex;justify-content:space-between;gap:10px;color:var(--muted);font-size:12px;font-weight:900;margin-bottom:8px}
.prow b{color:var(--text)}
.bar{height:12px;border-radius:999px;background:#eef2ff;border:1px solid #e0e7ff;overflow:hidden}
.fill{height:100%;width:0%;background:linear-gradient(90deg,#22c55e,#f59e0b,#ef4444)}
.limitBox{display:flex;gap:8px;align-items:center}
.limitBox input{
  width:96px;padding:9px 10px;border-radius:14px;border:1px solid var(--border);outline:none;
  font-weight:950;font-size:12px;background:#fff;
}
.limitBox input:focus{border-color:rgba(37,99,235,.35);box-shadow:0 0 0 4px rgba(37,99,235,.12)}

/* Expand area */
.expand{
  margin-top:10px;
  border-radius:16px;
  border:1px solid var(--border);
  background:#fff;
  overflow:hidden;
  display:none;
}
.expand.open{display:block}
.expandHead{
  padding:12px 12px;
  display:flex;
  justify-content:space-between;
  gap:10px;
  align-items:center;
  border-bottom:1px solid var(--border);
  background:#f7faff;
}
.noteRow{
  display:flex;gap:8px;align-items:center;flex-wrap:wrap;
}
.noteRow input{
  flex:1;min-width:260px;
  padding:10px 12px;border-radius:14px;border:1px solid var(--border);outline:none;font-size:13px;background:#fff;
}
.noteRow input:focus{border-color:rgba(37,99,235,.35);box-shadow:0 0 0 4px rgba(37,99,235,.12)}
.tableWrap{overflow:auto;max-height:420px}
table{width:100%;border-collapse:separate;border-spacing:0}
thead th{
  position:sticky;top:0;z-index:2;
  text-align:left;font-size:12px;color:var(--muted);font-weight:950;
  background:#f7faff;padding:11px 10px;border-bottom:1px solid var(--border);white-space:nowrap;
}
tbody td{padding:11px 10px;border-bottom:1px solid var(--border);font-size:13px;white-space:nowrap}
tbody tr:hover td{background:#fbfdff}
tbody tr:last-child td{border-bottom:none}
.os{display:inline-flex;align-items:center;gap:8px;padding:4px 10px;border-radius:999px;border:1px solid var(--border);background:#fff;font-weight:950;font-size:12px}
.os.win{border-color:#dbeafe;background:#eff6ff;color:#1d4ed8}
.os.lin{border-color:#dcfce7;background:#f0fdf4;color:#166534}

/* Loading overlay + skeleton */
.overlay{
  position:fixed;inset:0;
  display:none;
  background:rgba(246,248,252,.68);
  backdrop-filter: blur(6px);
  z-index:50;
}
.overlay.show{display:block}
.loaderCard{
  width:min(880px, calc(100% - 32px));
  margin:70px auto 0;
  background:#fff;border:1px solid var(--border);
  border-radius:20px;box-shadow:var(--shadow);
  padding:16px;
}
.skRow{height:14px;border-radius:999px;background:linear-gradient(90deg,#eef2ff,#f3f6ff,#eef2ff);background-size:200% 100%;animation:sk 1.2s infinite}
.skRow.w40{width:40%} .skRow.w55{width:55%} .skRow.w75{width:75%}
.skBox{height:72px;border-radius:16px;background:linear-gradient(90deg,#eef2ff,#f3f6ff,#eef2ff);background-size:200% 100%;animation:sk 1.2s infinite;margin-top:10px}
@keyframes sk{0%{background-position:0% 0}100%{background-position:200% 0}}

/* Toast */
.toastWrap{position:fixed;right:16px;bottom:16px;display:flex;flex-direction:column;gap:10px;z-index:60}
.toast{
  background:#fff;border:1px solid var(--border);border-radius:16px;
  box-shadow:var(--shadow2);padding:12px 14px;min-width:260px;
  display:flex;gap:10px;align-items:flex-start;
}
.toast .dot{width:10px;height:10px;border-radius:999px;margin-top:4px;background:var(--primary)}
.toast.ok .dot{background:var(--success)}
.toast.warn .dot{background:var(--warning)}
.toast.bad .dot{background:var(--danger)}
.toast .t{font-weight:950;font-size:13px}
.toast .s{margin-top:4px;color:var(--muted);font-size:12px}

.footer{text-align:center;font-size:12px;color:var(--muted);padding:10px 0 18px}

@media(max-width:1180px){
  .app{grid-template-columns:1fr}
  .sidebar{position:relative;height:auto}
  .kpis{grid-template-columns:repeat(2,minmax(0,1fr))}
  .accRow{grid-template-columns:1fr}
  .accRight{justify-content:flex-start}
  .progress{min-width:260px}
}
</style>
</head>

<body>
<div class="overlay" id="overlay">
  <div class="loaderCard">
    <div style="display:flex;justify-content:space-between;gap:10px;align-items:center">
      <div style="font-weight:950">Veriler yükleniyor…</div>
      <div style="color:var(--muted);font-weight:900;font-size:12px" id="overlayMsg">API çağrısı yapılıyor</div>
    </div>
    <div class="skRow w55" style="margin-top:12px"></div>
    <div class="skRow w40" style="margin-top:10px"></div>
    <div class="skBox"></div>
    <div class="skBox"></div>
  </div>
</div>
<div class="toastWrap" id="toasts"></div>

<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="logo"></div>
      <div>
        <div class="t">EC2 Control Panel</div>
        <div class="s" id="subBrand">Fast UI • Click-to-expand • Multi-account</div>
      </div>
    </div>

    <div class="nav">
      <button class="active" data-view="dashboard">
        <div class="left">
          <svg class="ico" viewBox="0 0 24 24" fill="none"><path d="M4 13h7V4H4v9Zm9 7h7V11h-7v9ZM4 20h7v-5H4v5Zm9-11h7V4h-7v5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
          <div class="lbl">Dashboard</div>
        </div>
        <span class="pill" id="pillAcc">0</span>
      </button>

      <button data-view="limits">
        <div class="left">
          <svg class="ico" viewBox="0 0 24 24" fill="none"><path d="M12 3v18M3 12h18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M7 7h10v10H7V7Z" stroke="currentColor" stroke-width="2"/></svg>
          <div class="lbl">Limits</div>
        </div>
        <span class="pill" id="pillOver">0</span>
      </button>

      <button data-view="terminated">
        <div class="left">
          <svg class="ico" viewBox="0 0 24 24" fill="none"><path d="M8 7h8M8 11h8M8 15h5" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M6 3h12a2 2 0 0 1 2 2v14l-4-2H6a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2Z" stroke="currentColor" stroke-width="2"/></svg>
          <div class="lbl">Terminated Log</div>
        </div>
        <span class="pill" id="pillTerm">0</span>
      </button>

      <button data-view="cache">
        <div class="left">
          <svg class="ico" viewBox="0 0 24 24" fill="none"><path d="M20 12a8 8 0 1 1-2.34-5.66" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M20 4v6h-6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
          <div class="lbl">Cache</div>
        </div>
        <span class="pill" id="pillCache">—</span>
      </button>

      <button data-view="settings">
        <div class="left">
          <svg class="ico" viewBox="0 0 24 24" fill="none"><path d="M12 15.5A3.5 3.5 0 1 0 12 8.5a3.5 3.5 0 0 0 0 7Z" stroke="currentColor" stroke-width="2"/></svg>
          <div class="lbl">Settings</div>
        </div>
        <span class="pill">UI</span>
      </button>
    </div>

    <div class="sidebox">
      <div class="row"><span>Default limit</span><b id="sideLimit">$120</b></div>
      <div class="row"><span>Trigger</span><b>UPTIME</b></div>
      <div class="row"><span>CE</span><b>NA / DU</b></div>
      <div class="row"><span>Cache TTL</span><b id="sideTTL">—</b></div>
    </div>
  </aside>

  <main class="main">
    <section class="header">
      <div class="hgroup">
        <h1 class="h1" id="pageTitle">Dashboard</h1>
        <div class="sub" id="pageSub">Hesap satırına tıklayın → açılır, not + instance tablosu görünür.</div>
      </div>
      <div class="actions">
        <button class="btn ghost" id="btnOnlyOver">
          <svg viewBox="0 0 24 24" fill="none"><path d="M3 12h18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M7 8h10M7 16h6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
          Limit Aşanlar
        </button>
        <button class="btn" id="btnRefresh">
          <svg viewBox="0 0 24 24" fill="none"><path d="M20 12a8 8 0 1 1-2.34-5.66" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M20 4v6h-6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
          Refresh
        </button>
        <button class="btn danger" id="btnClearCache">
          <svg viewBox="0 0 24 24" fill="none"><path d="M4 7h16" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
          Cache Temizle
        </button>
        <button class="btn primary" id="btnRunCron">
          <svg viewBox="0 0 24 24" fill="none"><path d="M12 2v6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M4 12h6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M14 12h6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
          Cron Çalıştır
        </button>
      </div>
    </section>

    <section class="kpis">
      <div class="kpi">
        <div class="top"><div class="label">Accounts</div><div class="tag ok" id="tagAcc">OK</div></div>
        <div class="value" id="kAcc">0</div>
        <div class="hint">CSV ile yönetilen hesap sayısı</div>
      </div>
      <div class="kpi">
        <div class="top"><div class="label">Instances</div><div class="tag ok" id="tagIns">LIVE</div></div>
        <div class="value" id="kIns">0</div>
        <div class="hint">Terminated hariç toplam instance</div>
      </div>
      <div class="kpi">
        <div class="top"><div class="label">Over Limit</div><div class="tag warn" id="tagOver">WARN</div></div>
        <div class="value" id="kOver">0</div>
        <div class="hint">Uptime $ >= limit olan hesaplar</div>
      </div>
      <div class="kpi">
        <div class="top"><div class="label">Uptime Hours</div><div class="tag ok">SUM</div></div>
        <div class="value" id="kUp">—</div>
        <div class="hint">Tüm hesaplar toplam çalışma saati</div>
      </div>
    </section>

    <section class="toolbar">
      <div class="search">
        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" style="opacity:.6"><path d="M21 21l-4.3-4.3" stroke="currentColor" stroke-width="2" stroke-linecap="round"/><path d="M10.5 18a7.5 7.5 0 1 1 0-15 7.5 7.5 0 0 1 0 15Z" stroke="currentColor" stroke-width="2"/></svg>
        <input id="q" placeholder="Ara: hesap / bölge / OS / type..." autocomplete="off">
      </div>

      <select class="select" id="filter">
        <option value="all">Tümü</option>
        <option value="over">Sadece limit aşan</option>
      </select>

      <select class="select" id="size">
        <option value="10">10 / sayfa</option>
        <option value="20" selected>20 / sayfa</option>
        <option value="50">50 / sayfa</option>
      </select>

      <div class="meta" id="meta">—</div>
    </section>

    <section class="list">
      <div class="listhead">
        <div style="font-weight:950;letter-spacing:.2px">Accounts</div>
        <div class="pages">
          <button class="pagebtn" id="prev">◀</button>
          <div class="pageinfo" id="pageInfo">1 / 1</div>
          <button class="pagebtn" id="next">▶</button>
        </div>
      </div>
      <div id="list"></div>
    </section>

    <div class="footer">EC2 Control Panel • api.php + action.php</div>
  </main>
</div>

<script>
const $ = s => document.querySelector(s);

let RAW=null, VIEW='dashboard', PAGE=1, ONLY_OVER=false;

/* ===== helpers ===== */
function esc(s){
  return (s??'').toString()
    .replaceAll('&','&amp;').replaceAll('<','&lt;').replaceAll('>','&gt;')
    .replaceAll('"','&quot;').replaceAll("'","&#039;");
}
function money(n){
  if(n==null||n===''||isNaN(Number(n))) return '—';
  return '$'+Number(n).toFixed(2);
}
function pct(v,m){
  if(!m||m<=0) return 0;
  return Math.max(0, Math.min(100, (v/m)*100));
}
function normalizeCE(v){
  const t=(v??'NA').toString().toUpperCase();
  if(t==='DU') return 'DU';
  if(t==='NA' || t==='N/A') return 'NA';
  if(!isNaN(Number(v))) return Number(v).toFixed(2);
  return t || 'NA';
}

/* ===== toast ===== */
function toast(type, title, subtitle){
  const wrap = $('#toasts');
  const el = document.createElement('div');
  el.className = 'toast ' + (type||'');
  el.innerHTML = `<div class="dot"></div><div><div class="t">${esc(title||'')}</div><div class="s">${esc(subtitle||'')}</div></div>`;
  wrap.appendChild(el);
  setTimeout(()=>{ el.style.opacity='0'; el.style.transform='translateY(6px)'; }, 2600);
  setTimeout(()=>{ el.remove(); }, 3200);
}

/* ===== overlay ===== */
function setLoading(on, msg){
  const ov = $('#overlay');
  if(on){
    $('#overlayMsg').textContent = msg || 'Yükleniyor';
    ov.classList.add('show');
  } else {
    ov.classList.remove('show');
  }
}

/* ===== api ===== */
async function api(){
  const r = await fetch('api.php?ts='+Date.now(), {cache:'no-store'});
  const j = await r.json();
  if(!j.ok) throw new Error(j.msg||'api error');
  return j;
}
async function post(action,payload={}){
  const body = new URLSearchParams({action, ...payload});
  const r = await fetch('action.php', {
    method:'POST',
    headers:{'Content-Type':'application/x-www-form-urlencoded'},
    body
  });
  const j = await r.json();
  if(!j.ok) throw new Error(j.msg||'action error');
  return j;
}

/* ===== ui ===== */
function setNav(){
  document.querySelectorAll('.nav button').forEach(b=>{
    b.classList.toggle('active', b.dataset.view===VIEW);
  });
  const titles={dashboard:'Dashboard',limits:'Limits',terminated:'Terminated Log',cache:'Cache',settings:'Settings'};
  $('#pageTitle').textContent = titles[VIEW] || 'Dashboard';
  const subs={
    dashboard:'Hesap satırına tıklayın → açılır, not + instance tablosu görünür.',
    limits:'Limit aşan hesaplar filtrelenir.',
    terminated:'Cron terminate ettiği hesaplar.',
    cache:'Cache temizle / cron çalıştır.',
    settings:'UI (demo).'
  };
  $('#pageSub').textContent = subs[VIEW] || '';
}

function updateTop(j){
  const m=j.meta||{}, s=j.summary||{};
  $('#sideLimit').textContent = '$' + (m.default_limit ?? 120);
  $('#sideTTL').textContent = m.cache_ttl ?? '—';

  const accCount = s.accounts ?? (j.accounts?.length ?? 0);
  $('#kAcc').textContent = accCount;
  $('#kIns').textContent = s.instances ?? 0;
  $('#kOver').textContent = s.over_limit ?? 0;
  $('#kUp').textContent = (s.uptime_total_hours!=null) ? Number(s.uptime_total_hours).toFixed(2)+'h' : '—';

  $('#pillAcc').textContent = accCount;
  $('#pillOver').textContent = s.over_limit ?? 0;
  $('#pillTerm').textContent = j.terminated_count ?? 0;
  $('#pillCache').textContent = m.cache_ttl ?? '—';

  $('#tagOver').className = 'tag ' + (((s.over_limit ?? 0) > 0) ? 'warn' : 'ok');
  $('#meta').textContent = 'Son güncelleme: ' + (m.generated_at || '—');
}

function filterAccounts(){
  if(VIEW==='cache' || VIEW==='settings') return [];
  let arr = (RAW?.accounts || []).slice();

  if(VIEW==='limits') arr = arr.filter(a => Number(a.is_over_limit)===1);
  if(VIEW==='terminated') arr = (RAW?.terminated_accounts || []).slice();

  if(ONLY_OVER || $('#filter').value==='over'){
    arr = arr.filter(a => Number(a.is_over_limit)===1);
  }

  const q = ($('#q').value || '').trim().toLowerCase();
  if(q){
    arr = arr.filter(a=>{
      const hay = [
        a.name, a.account_id, a.csv, a.note,
        ...(a.instances || []).map(i => [i.region_label, i.type, i.os].join(' '))
      ].join(' ').toLowerCase();
      return hay.includes(q);
    });
  }

  arr.sort((a,b)=>{
    const ao = Number(a.is_over_limit)||0;
    const bo = Number(b.is_over_limit)||0;
    if(ao!==bo) return bo-ao;
    return (a.name||'').localeCompare(b.name||'','tr');
  });
  return arr;
}

function paginate(arr){
  const per = Number($('#size').value)||20;
  const pages = Math.max(1, Math.ceil(arr.length / per));
  PAGE = Math.min(PAGE, pages);
  $('#pageInfo').textContent = PAGE + ' / ' + pages;
  const start=(PAGE-1)*per;
  return arr.slice(start, start+per);
}

function accountHtml(a, idx){
  const limit = Number(a.limit ?? 120);
  const spent = Number(a.uptime_cost_total ?? 0);
  const p = pct(spent, limit);
  const over = Number(a.is_over_limit)===1 || spent>=limit;

  const badge = over ? `<span class="badge red">Limit aşan</span>` : `<span class="badge green">Normal</span>`;
  const running = Number(a.running ?? 0);
  const instCount = Number(a.instance_count ?? (a.instances||[]).length);

  const ce24 = normalizeCE(a.ce24);
  const cemo = normalizeCE(a.cemonth);

  const rows = (a.instances || []).map(i=>{
    const reg = esc(i.region_label || i.region || '—');
    const type = esc(i.type || '—');
    const os = esc(i.os || '—');
    const isWin = (os||'').toLowerCase().includes('win');
    const osPill = `<span class="os ${isWin?'win':'lin'}">${os}</span>`;
    const hrs = (i.uptime_hours!=null && !isNaN(Number(i.uptime_hours))) ? Number(i.uptime_hours).toFixed(2)+'h' : '—';
    const rate = (i.hourly!=null && !isNaN(Number(i.hourly))) ? '$'+Number(i.hourly).toFixed(4) : '—';
    const cost = (i.uptime_cost!=null && !isNaN(Number(i.uptime_cost))) ? money(i.uptime_cost) : '—';
    const region = i.region || '';
    const iid = i.instance_id || '';

    const btn = (region && iid)
      ? `<button class="btn small danger" data-act="terminate" data-csv="${esc(a.csv)}" data-region="${esc(region)}" data-iid="${esc(iid)}">Terminate</button>`
      : '—';

    return `<tr>
      <td>${reg}</td>
      <td>${type}</td>
      <td>${osPill}</td>
      <td>${hrs}</td>
      <td>${rate}</td>
      <td>${cost}</td>
      <td>${btn}</td>
    </tr>`;
  }).join('');

  return `
  <div class="account ${over?'over':''}" data-acc="${idx}">
    <div class="accRow" data-toggle="${idx}">
      <div>
        <div class="nameLine">
          <div class="name">${esc(a.name || 'Account')}</div>
          ${badge}
          <span class="badge">${esc(a.account_id || '—')}</span>
        </div>
        <div class="chips">
          <span class="chip">Running: <b>${running}</b></span>
          <span class="chip">Inst: <b>${instCount}</b></span>
          <span class="chip">Uptime $: <b>${money(spent)}</b></span>
          <span class="chip mono">CE 24h: <b>${esc(ce24)}</b></span>
          <span class="chip mono">CE month: <b>${esc(cemo)}</b></span>
        </div>
      </div>

      <div class="accRight" onclick="event.stopPropagation()">
        <div class="progress">
          <div class="prow"><span><b>${money(spent)}</b> / ${money(limit)}</span><span>${p.toFixed(0)}%</span></div>
          <div class="bar"><div class="fill" style="width:${p}%"></div></div>
        </div>

        <div class="limitBox">
          <input type="number" min="0" step="1" value="${limit}" data-limit="${idx}">
          <button class="btn small" data-act="save_limit" data-csv="${esc(a.csv)}" data-idx="${idx}">Limit</button>
        </div>
      </div>
    </div>

    <div class="expand" id="exp-${idx}">
      <div class="expandHead">
        <div style="font-weight:950">Not & İşlemler</div>
        <div style="display:flex;gap:8px;flex-wrap:wrap">
          <button class="btn small danger" data-act="delete_account" data-csv="${esc(a.csv)}">Hesabı Sil</button>
        </div>
      </div>

      <div style="padding:12px">
        <div class="noteRow">
          <input value="${esc(a.note || '')}" placeholder="Bu hesaba not ekle..." data-note="${idx}">
          <button class="btn small ghost" data-act="save_note" data-csv="${esc(a.csv)}" data-idx="${idx}">Not Kaydet</button>
        </div>
      </div>

      <div class="tableWrap">
        <table>
          <thead>
            <tr>
              <th>Bölge</th><th>Type</th><th>OS</th><th>Çalışma</th><th>Saatlik</th><th>Uptime $</th><th></th>
            </tr>
          </thead>
          <tbody>
            ${rows || `<tr><td colspan="7" style="color:var(--muted);font-weight:900">Bu hesapta aktif instance yok</td></tr>`}
          </tbody>
        </table>
      </div>
    </div>
  </div>`;
}

function render(){
  setNav();

  if(!RAW){
    $('#list').innerHTML = '';
    return;
  }

  updateTop(RAW);

  if(VIEW==='cache'){
    $('#list').innerHTML = `
      <div class="account">
        <div style="padding:12px 4px;font-weight:950">Cache Yönetimi</div>
        <div style="padding:0 4px 12px;color:var(--muted);font-weight:900;font-size:12px">
          TTL: ${esc(RAW.meta?.cache_ttl || '—')} • Generated: ${esc(RAW.meta?.generated_at || '—')}
        </div>
      </div>`;
    return;
  }

  if(VIEW==='settings'){
    $('#list').innerHTML = `
      <div class="account">
        <div style="padding:12px 4px;font-weight:950">Settings (demo)</div>
        <div style="padding:0 4px 12px;color:var(--muted);font-weight:900;font-size:12px">
          Tema: Light • Bar: Color accent • Expand: click-anywhere
        </div>
      </div>`;
    return;
  }

  const arr = filterAccounts();
  const items = paginate(arr);
  $('#list').innerHTML = items.map((a,i)=> accountHtml(a,i)).join('');

  // Click anywhere on bar (except controls) to expand
  document.querySelectorAll('[data-toggle]').forEach(row=>{
    row.addEventListener('click', ()=>{
      const id = row.dataset.toggle;
      const box = document.getElementById('exp-'+id);
      const open = box.classList.toggle('open');
      // close others? İstersen açarım; şimdilik çoklu açılabilir.
    });
  });

  // Prevent bar toggle when clicking inside inputs/buttons
  document.querySelectorAll('input,button,select').forEach(el=>{
    el.addEventListener('click', (e)=> e.stopPropagation());
  });

  // Actions
  document.querySelectorAll('[data-act]').forEach(b=>{
    b.onclick = async(e)=>{
      e.stopPropagation();
      const act = b.dataset.act;
      try{
        if(act==='save_limit'){
          const idx=b.dataset.idx;
          const inp=document.querySelector(`[data-limit="${idx}"]`);
          setLoading(true,'Limit kaydediliyor…');
          await post('save_limit',{csv:b.dataset.csv,limit:inp.value});
          setLoading(false);
          toast('ok','Limit kaydedildi', b.dataset.csv);
          await reload(true);
        }
        if(act==='save_note'){
          const idx=b.dataset.idx;
          const inp=document.querySelector(`[data-note="${idx}"]`);
          setLoading(true,'Not kaydediliyor…');
          await post('save_note',{csv:b.dataset.csv,note:inp.value});
          setLoading(false);
          toast('ok','Not kaydedildi', b.dataset.csv);
          // not için full reload şart değil ama senkron olsun diye hafif refresh:
          await reload(false);
        }
        if(act==='delete_account'){
          if(!confirm('Bu hesabın CSV dosyası silinsin mi?')) return;
          setLoading(true,'Hesap siliniyor…');
          await post('delete_account',{csv:b.dataset.csv});
          setLoading(false);
          toast('ok','Hesap silindi', b.dataset.csv);
          await reload(true);
        }
        if(act==='terminate'){
          if(!confirm('Instance terminate edilsin mi?')) return;
          setLoading(true,'Terminate gönderiliyor…');
          await post('terminate_one',{csv:b.dataset.csv,region:b.dataset.region,instance:b.dataset.iid});
          setLoading(false);
          toast('warn','Terminate gönderildi', b.dataset.iid);
          await reload(true);
        }
      }catch(err){
        setLoading(false);
        toast('bad','Hata', err.message || String(err));
      }
    };
  });
}

/* reload: hard=true -> overlay + force UI update */
async function reload(hard=true){
  if(hard) setLoading(true,'API verisi alınıyor…');
  try{
    RAW = await api();
    render();
  }catch(e){
    $('#meta').textContent = 'API hata: ' + (e.message || String(e));
    toast('bad','API Hatası', e.message || String(e));
  }finally{
    if(hard) setLoading(false);
  }
}

/* events */
$('#btnRefresh').onclick = ()=> reload(true);
$('#btnClearCache').onclick = async()=> {
  try{
    setLoading(true,'Cache temizleniyor…');
    await post('clear_cache',{});
    toast('ok','Cache temizlendi','');
    await reload(true);
  }catch(e){
    setLoading(false);
    toast('bad','Hata', e.message || String(e));
  }
};
$('#btnRunCron').onclick = async()=>{
  try{
    setLoading(true,'Cron çalışıyor…');
    const r = await post('run_cron',{});
    toast('warn','Cron tamamlandı', 'Terminated: '+(r.terminated ?? 0));
    await reload(true);
  }catch(e){
    setLoading(false);
    toast('bad','Hata', e.message || String(e));
  }
};

$('#btnOnlyOver').onclick = ()=>{
  ONLY_OVER = !ONLY_OVER;
  $('#filter').value = ONLY_OVER ? 'over' : 'all';
  PAGE=1;
  render();
};

$('#q').oninput = ()=>{ PAGE=1; render(); };
$('#filter').onchange = ()=>{ PAGE=1; render(); };
$('#size').onchange = ()=>{ PAGE=1; render(); };
$('#prev').onclick = ()=>{ PAGE=Math.max(1,PAGE-1); render(); };
$('#next').onclick = ()=>{ PAGE=PAGE+1; render(); };

document.querySelectorAll('.nav button').forEach(b=>{
  b.onclick = ()=>{ VIEW=b.dataset.view; PAGE=1; render(); };
});

/* IMPORTANT: ilk açılışta boş kalmasın -> DOMContentLoaded’da overlay + reload */
document.addEventListener('DOMContentLoaded', ()=>{
  setLoading(true,'Panel hazırlanıyor…');
  reload(true);
});
</script>
</body>
</html>