<?php
require "/home/mstrxgcf/vendor/autoload.php";

define("APP_INIT", true);
require "/home/mstrxgcf/terminate-app/lib.php";

header("Content-Type: application/json; charset=utf-8");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(["ok"=>false,"msg"=>"POST required"], JSON_UNESCAPED_UNICODE);
  exit;
}

$action = trim($_POST['action'] ?? '');

try {

  if ($action === 'clear_cache') {
    clear_all_cache();
    echo json_encode(["ok"=>true], JSON_UNESCAPED_UNICODE);
    exit;
  }

  if ($action === 'set_limit') {
    $account = trim($_POST['account'] ?? '');
    $limit = trim($_POST['limit'] ?? '');
    if ($account === '' || $limit === '' || !is_numeric($limit)) {
      echo json_encode(["ok"=>false,"msg"=>"account/limit invalid"], JSON_UNESCAPED_UNICODE);
      exit;
    }

    $c = find_account_creds_by_name($account);
    if (!$c) { echo json_encode(["ok"=>false,"msg"=>"account not found"], JSON_UNESCAPED_UNICODE); exit; }

    $accId = get_account_id($c['ak'],$c['sk']);
    $key = $accId ?: $account;

    set_limit_for_account($key, (float)$limit);
    echo json_encode(["ok"=>true,"key"=>$key,"limit"=>(float)$limit], JSON_UNESCAPED_UNICODE);
    exit;
  }

  if ($action === 'set_note') {
    $account = trim($_POST['account'] ?? '');
    $note = trim($_POST['note'] ?? '');

    if ($account === '') {
      echo json_encode(["ok"=>false,"msg"=>"account required"], JSON_UNESCAPED_UNICODE);
      exit;
    }

    $c = find_account_creds_by_name($account);
    if (!$c) { echo json_encode(["ok"=>false,"msg"=>"account not found"], JSON_UNESCAPED_UNICODE); exit; }

    $accId = get_account_id($c['ak'],$c['sk']);
    $key = $accId ?: $account;

    set_note($key, $note);
    echo json_encode(["ok"=>true], JSON_UNESCAPED_UNICODE);
    exit;
  }

  if ($action === 'delete_account') {
    $account = trim($_POST['account'] ?? '');
    if ($account === '') { echo json_encode(["ok"=>false,"msg"=>"account required"], JSON_UNESCAPED_UNICODE); exit; }
    $r = delete_account_csv_by_name($account);
    echo json_encode($r, JSON_UNESCAPED_UNICODE);
    exit;
  }

  if ($action === 'terminate_instance' || $action === 'stop_instance') {
    $account = trim($_POST['account'] ?? '');
    $iid = trim($_POST['instance_id'] ?? '');
    $region = trim($_POST['region'] ?? '');

    if ($account === '' || $iid === '') {
      echo json_encode(["ok"=>false,"msg"=>"account/instance_id required"], JSON_UNESCAPED_UNICODE);
      exit;
    }

    $c = find_account_creds_by_name($account);
    if (!$c) { echo json_encode(["ok"=>false,"msg"=>"account not found"], JSON_UNESCAPED_UNICODE); exit; }

    if ($region === '') {
      $inst = scan_instances_for_account($c['ak'],$c['sk']);
      foreach($inst as $x){
        if (($x['instance_id'] ?? '') === $iid) { $region = $x['region'] ?? ''; break; }
      }
    }
    if ($region === '') {
      echo json_encode(["ok"=>false,"msg"=>"region not found for instance"], JSON_UNESCAPED_UNICODE);
      exit;
    }

    if ($action === 'terminate_instance') {
      terminate_instance($c['ak'],$c['sk'],$region,$iid);
      clear_all_cache();
      echo json_encode(["ok"=>true,"action"=>"terminate","region"=>$region], JSON_UNESCAPED_UNICODE);
      exit;
    } else {
      stop_instance($c['ak'],$c['sk'],$region,$iid);
      clear_all_cache();
      echo json_encode(["ok"=>true,"action"=>"stop","region"=>$region], JSON_UNESCAPED_UNICODE);
      exit;
    }
  }

  echo json_encode(["ok"=>false,"msg"=>"unknown action"], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  app_log("run.php error: ".$e->getMessage());
  echo json_encode(["ok"=>false,"msg"=>"server error","detail"=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
}